# Kneitel_2010_algae_Dunnett2.sas
# One-way ANOVA and Tukey method

# Load necessary libraries
library(ggplot2)
library(multcomp)

# Read in data set
kndata <- read.table(header=T,colClasses=c("factor","numeric","numeric","numeric"),
text="
treat richness total algae
Control   8   78    1
Control   5   84    7
Control  10	 115   45
Control   7	 200  100
Control   6   72   20
Low       8   73   15
Low       7  124   70
Low       8  116   50
Low       8   92    5
Low       7  138   60
Medium    7  124   85
Medium    8  116   80
Medium    8  145   60
Medium    6  154  100
Medium    7  129   90
High      6  134   95
High      7  138   95
High      8  103   70
High      8  119   75
High	  6  132   80
VeryHigh  6  148   95
VeryHigh  5  134   95
VeryHigh  5  119  100
VeryHigh  5  117   90
VeryHigh  5  129   80
")

# Apply transformations here
kndata <- transform(kndata,y=asin(sqrt(algae/100)))

# Print data
kndata

# Graphics using ggplot2
ggplot(kndata,aes(treat,y))+
geom_jitter(size=2,position=position_jitter(width=0.1))+
stat_summary(fun="mean",geom="point",size=3)+
stat_summary(fun.data="mean_cl_normal",geom="errorbar",width=0.2,linewidth=1)

# One-way ANOVA
aovout <- aov(y~treat,data=kndata)
anova(aovout)

# Obtain multiple comparison object
compout <- glht(aovout,linfct=mcp(treat="Dunnett"))

# Dunnett's method - controls the EER for comparisons with a control
dunnout <- summary(compout)
dunnout
confint(dunnout)

# Diagnostic plots to check ANOVA assumptions
p <- predict(aovout)
r <- resid(aovout)
plot(p,r)
qqnorm(r)
